////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) since 1999. VASCO DATA SECURITY
// All rights reserved. http://www.vasco.com
//
////////////////////////////////////////////////////////////////////////////////

#import <MSSOrchestration/ActivationParams.h>
NS_ASSUME_NONNULL_BEGIN

@protocol OnlineActivationDelegate;
@class OrchestrationUser;

/**
 * <p>A {@link OnlineActivationParams} object provides parameters for a online activation process.</p>
 */
NS_REFINED_FOR_SWIFT
@interface OnlineActivationParams : ActivationParams

/**
 * Gets the configured user for performing a local authentication.
 * @return the configured user
 */
@property (nonatomic, strong) OrchestrationUser *orchestrationUser;

/**
 * The activation password to be used during the online activation

 */
@property (nonatomic, copy) NSString *activationPassword;

/**
 * Sets the {@link OnlineActivationDelegate} to be notified about activation events.
 *
 * @param activationDelegate a {@link OnlineActivationDelegate} object
 */
- (void)setActivationDelegate:(id<OnlineActivationDelegate>)activationDelegate;

@end

NS_ASSUME_NONNULL_END
